<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-bar-chart"></i> 
                                    <?php echo $title; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('workshop/reports'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> <?php echo _l('back'); ?>
                                </a>
                            </div>
                        </div>
                        <hr class="hr-panel-heading" />

                        <!-- Summary Cards -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="panel panel-default">
                                    <div class="panel-body text-center">
                                        <h3 class="bold"><?php echo $total_devices; ?></h3>
                                        <p>Всего устройств</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-success">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-success"><?php echo $devices_good; ?></h3>
                                        <p>Хорошее состояние</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-warning">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-warning"><?php echo $devices_fair + $devices_attention; ?></h3>
                                        <p>Требует внимания</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-danger">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-danger"><?php echo $devices_critical; ?></h3>
                                        <p>Критическое</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Filters -->
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <i class="fa fa-filter"></i> <?php echo _l('filter'); ?>
                            </div>
                            <div class="panel-body">
                                <?php echo form_open(admin_url('workshop/report_device_condition'), ['method' => 'get']); ?>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?php echo _l('client'); ?></label>
                                            <select name="client_id" class="form-control selectpicker" data-live-search="true">
                                                <option value=""><?php echo _l('all'); ?></option>
                                                <?php foreach ($clients as $client) { ?>
                                                    <option value="<?php echo $client['userid']; ?>" 
                                                        <?php echo (isset($filters['client_id']) && $filters['client_id'] == $client['userid']) ? 'selected' : ''; ?>>
                                                        <?php echo $client['company']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Возраст техники</label>
                                            <select name="age_filter" class="form-control selectpicker">
                                                <option value=""><?php echo _l('all'); ?></option>
                                                <option value="new" <?php echo (isset($filters['age_filter']) && $filters['age_filter'] == 'new') ? 'selected' : ''; ?>>
                                                    Новая (до 1 года)
                                                </option>
                                                <option value="1-2" <?php echo (isset($filters['age_filter']) && $filters['age_filter'] == '1-2') ? 'selected' : ''; ?>>
                                                    1-2 года
                                                </option>
                                                <option value="3-5" <?php echo (isset($filters['age_filter']) && $filters['age_filter'] == '3-5') ? 'selected' : ''; ?>>
                                                    3-5 лет
                                                </option>
                                                <option value="5+" <?php echo (isset($filters['age_filter']) && $filters['age_filter'] == '5+') ? 'selected' : ''; ?>>
                                                    Более 5 лет
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?php echo _l('wshop_model'); ?></label>
                                            <select name="model_id" class="form-control selectpicker">
                                                <option value=""><?php echo _l('all'); ?></option>
                                                <?php foreach ($models as $model) { ?>
                                                    <option value="<?php echo $model['id']; ?>"
                                                        <?php echo (isset($filters['model_id']) && $filters['model_id'] == $model['id']) ? 'selected' : ''; ?>>
                                                        <?php echo isset($model['name']) ? $model['name'] : (isset($model['model_name']) ? $model['model_name'] : ''); ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Мин. ремонтов за год</label>
                                            <input type="number" name="min_repairs" class="form-control" min="0"
                                                value="<?php echo isset($filters['min_repairs']) ? $filters['min_repairs'] : ''; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-info">
                                            <i class="fa fa-filter"></i> <?php echo _l('wshop_apply_filter'); ?>
                                        </button>
                                        <a href="<?php echo admin_url('workshop/report_device_condition'); ?>" class="btn btn-default">
                                            <i class="fa fa-remove"></i> <?php echo _l('wshop_clear_filter'); ?>
                                        </a>
                                        
                                        <?php if (!empty($devices)) { ?>
                                            <div class="btn-group pull-right">
                                                <a href="<?php echo admin_url('workshop/export_device_condition_excel?' . http_build_query($filters)); ?>" 
                                                   class="btn btn-success">
                                                    <i class="fa fa-file-excel-o"></i> <?php echo _l('wshop_export_excel'); ?>
                                                </a>
                                                <a href="<?php echo admin_url('workshop/export_device_condition_pdf?' . http_build_query($filters)); ?>" 
                                                   class="btn btn-danger">
                                                    <i class="fa fa-file-pdf-o"></i> <?php echo _l('wshop_export_pdf'); ?>
                                                </a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                                <?php echo form_close(); ?>
                            </div>
                        </div>

                        <!-- Data Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Код</th>
                                        <th>Название</th>
                                        <th>Клиент</th>
                                        <th>Категория</th>
                                        <th class="text-center">Всего ремонтов</th>
                                        <th class="text-center">За 12 мес.</th>
                                        <th class="text-right">Стоимость</th>
                                        <th class="text-center">Состояние</th>
                                        <th>Последний ремонт</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($devices)) { ?>
                                        <?php foreach ($devices as $device) { 
                                            $status_class = '';
                                            $status_label = '';
                                            switch ($device['condition_status']) {
                                                case 'good':
                                                    $status_class = 'success';
                                                    $status_label = 'Хорошее';
                                                    break;
                                                case 'fair':
                                                    $status_class = 'info';
                                                    $status_label = 'Удовлетворительное';
                                                    break;
                                                case 'attention':
                                                    $status_class = 'warning';
                                                    $status_label = 'Требует внимания';
                                                    break;
                                                case 'critical':
                                                    $status_class = 'danger';
                                                    $status_label = 'Критическое';
                                                    break;
                                            }
                                        ?>
                                        <tr>
                                            <td>
                                                <a href="<?php echo admin_url('workshop/device_detail/' . $device['id']); ?>">
                                                    <?php echo $device['code']; ?>
                                                </a>
                                            </td>
                                            <td><?php echo $device['device_name']; ?></td>
                                            <td><?php echo $device['client_name']; ?></td>
                                            <td><?php echo $device['category_name']; ?></td>
                                            <td class="text-center"><?php echo $device['total_repairs']; ?></td>
                                            <td class="text-center"><strong><?php echo $device['repairs_12_months']; ?></strong></td>
                                            <td class="text-right"><?php echo app_format_money($device['total_repair_cost'], ''); ?></td>
                                            <td class="text-center">
                                                <span class="label label-<?php echo $status_class; ?>">
                                                    <?php echo $status_label; ?>
                                                </span>
                                            </td>
                                            <td><?php echo $device['last_repair_date'] ? _d($device['last_repair_date']) : '-'; ?></td>
                                        </tr>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr>
                                            <td colspan="9" class="text-center">Нет данных</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
